/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.parser.phpdoc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TypedDescription {
    private static final TypedDescription[] EMPTY_TYPED_DESCRIPTIONS = new TypedDescription[0];
    private static final String[] EMPTY_STR_ARR = new String[0];
    private ArrayList<String> fTypes;
    private ArrayList<TypedDescription> fDefaultValues;
    private String fDescription = "";
    private String fName = "";
    private static Map<String, String> builtInAliases = new HashMap<String, String>();

    static {
        builtInAliases.put("object", "Object");
        builtInAliases.put("function", "Function");
        builtInAliases.put("array", "Array");
        builtInAliases.put("date", "Date");
        builtInAliases.put("error", "Error");
        builtInAliases.put("string", "String");
        builtInAliases.put("char", "String");
        builtInAliases.put("Char", "String");
        builtInAliases.put("number", "Number");
        builtInAliases.put("int", "Number");
        builtInAliases.put("Int", "Number");
        builtInAliases.put("integer", "Number");
        builtInAliases.put("Integer", "Number");
        builtInAliases.put("float", "Number");
        builtInAliases.put("Float", "Number");
        builtInAliases.put("boolean", "Boolean");
        builtInAliases.put("Bool", "Boolean");
        builtInAliases.put("bool", "Boolean");
        builtInAliases.put("regEx", "RegExp");
        builtInAliases.put("RegEx", "RegExp");
        builtInAliases.put("regex", "RegExp");
        builtInAliases.put("regExp", "RegExp");
        builtInAliases.put("regexp", "RegExp");
    }

    public TypedDescription(String description, String name) {
        this.fDescription = description == null ? "" : description;
        this.fName = name == null ? "" : name;
    }

    public TypedDescription(String description) {
        this.fDescription = description == null ? "" : description;
    }

    public TypedDescription() {
    }

    public String[] getTypes() {
        if (this.fTypes == null) {
            return EMPTY_STR_ARR;
        }
        return this.fTypes.toArray(new String[this.fTypes.size()]);
    }

    public void clearTypes() {
        if (this.fTypes != null) {
            this.fTypes.clear();
        }
    }

    public void addType(String value) {
        String string = value = value == null ? "" : value;
        if (this.fTypes == null) {
            this.fTypes = new ArrayList();
        }
        String result = this.checkForBuiltInAlias(value);
        this.fTypes.add(result);
    }

    public TypedDescription[] getDefaultValues() {
        if (this.fDefaultValues == null) {
            return EMPTY_TYPED_DESCRIPTIONS;
        }
        return this.fDefaultValues.toArray(new TypedDescription[this.fDefaultValues.size()]);
    }

    public void clearDefaultValues() {
        if (this.fDefaultValues != null) {
            this.fDefaultValues.clear();
        }
    }

    public void addDefaultValue(TypedDescription value) {
        if (value == null) {
            return;
        }
        if (this.fDefaultValues == null) {
            this.fDefaultValues = new ArrayList();
        }
        this.fDefaultValues.add(value);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String value) {
        this.fName = value == null ? "" : value;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String value) {
        this.fDescription = value == null ? "" : value;
    }

    public void read(DataInput input) throws IOException {
        int i;
        int size = input.readInt();
        if (size > 0) {
            this.fDefaultValues = new ArrayList();
            i = 0;
            while (i < size) {
                TypedDescription param = new TypedDescription();
                param.read(input);
                this.fDefaultValues.add(param);
                ++i;
            }
        }
        if ((size = input.readInt()) > 0) {
            this.fTypes = new ArrayList();
            i = 0;
            while (i < size) {
                String type = input.readUTF();
                this.fTypes.add(type);
                ++i;
            }
        }
        this.fDescription = input.readUTF();
        this.fName = input.readUTF();
    }

    public void write(DataOutput output) throws IOException {
        int i;
        if (this.fDefaultValues != null) {
            output.writeInt(this.fDefaultValues.size());
            i = 0;
            while (i < this.fDefaultValues.size()) {
                TypedDescription param = this.fDefaultValues.get(i);
                param.write(output);
                ++i;
            }
        } else {
            output.writeInt(0);
        }
        if (this.fTypes != null) {
            output.writeInt(this.fTypes.size());
            i = 0;
            while (i < this.fTypes.size()) {
                output.writeUTF(this.fTypes.get(i));
                ++i;
            }
        } else {
            output.writeInt(0);
        }
        output.writeUTF(this.fDescription);
        output.writeUTF(this.fName);
    }

    private String checkForBuiltInAlias(String value) {
        if (builtInAliases.containsKey(value)) {
            return builtInAliases.get(value);
        }
        return value;
    }
}

